/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.service;

import java.util.ArrayList;
import java.util.List;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.base.request.auth.password.AuthAESPassword;
import pro.gravit.launcher.base.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.base.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.base.request.auth.password.AuthTOTPPassword;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.utils.helper.SecurityHelper;

public class AuthService {
    private final LauncherConfig config = Launcher.getConfig();
    private final JavaFXApplication application;
    private AuthRequestEvent rawAuthResult;
    private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;

    public AuthService(JavaFXApplication application) {
        this.application = application;
    }

    public AuthRequest.AuthPasswordInterface makePassword(String plainPassword) {
        if (this.config.passwordEncryptKey != null) {
            try {
                return new AuthAESPassword(this.encryptAESPassword(plainPassword));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new AuthPlainPassword(plainPassword);
    }

    public AuthRequest.AuthPasswordInterface make2FAPassword(AuthRequest.AuthPasswordInterface firstPassword, String totp) {
        Auth2FAPassword auth2FAPassword = new Auth2FAPassword();
        auth2FAPassword.firstPassword = firstPassword;
        auth2FAPassword.secondPassword = new AuthTOTPPassword();
        ((AuthTOTPPassword)auth2FAPassword.secondPassword).totp = totp;
        return auth2FAPassword;
    }

    public List<AuthRequest.AuthPasswordInterface> getListFromPassword(AuthRequest.AuthPasswordInterface password) {
        if (password instanceof Auth2FAPassword) {
            Auth2FAPassword auth2FAPassword = (Auth2FAPassword)password;
            ArrayList<AuthRequest.AuthPasswordInterface> list = new ArrayList<AuthRequest.AuthPasswordInterface>();
            list.add(auth2FAPassword.firstPassword);
            list.add(auth2FAPassword.secondPassword);
            return list;
        }
        if (password instanceof AuthMultiPassword) {
            AuthMultiPassword authMultiPassword = (AuthMultiPassword)password;
            return authMultiPassword.list;
        }
        ArrayList<AuthRequest.AuthPasswordInterface> list = new ArrayList<AuthRequest.AuthPasswordInterface>(1);
        list.add(password);
        return list;
    }

    public AuthRequest.AuthPasswordInterface getPasswordFromList(List<AuthRequest.AuthPasswordInterface> password) {
        if (password.size() == 1) {
            return password.get(0);
        }
        if (password.size() == 2) {
            Auth2FAPassword pass = new Auth2FAPassword();
            pass.firstPassword = password.get(0);
            pass.secondPassword = password.get(1);
            return pass;
        }
        AuthMultiPassword multi = new AuthMultiPassword();
        multi.list = password;
        return multi;
    }

    public AuthRequest makeAuthRequest(String login, AuthRequest.AuthPasswordInterface password, String authId) {
        return new AuthRequest(login, password, authId, false, this.application.isDebugMode() ? AuthRequest.ConnectTypes.API : AuthRequest.ConnectTypes.CLIENT);
    }

    private byte[] encryptAESPassword(String password) throws Exception {
        return SecurityHelper.encrypt((String)Launcher.getConfig().passwordEncryptKey, (String)password);
    }

    public void setAuthResult(String authId, AuthRequestEvent rawAuthResult) {
        this.rawAuthResult = rawAuthResult;
        if (rawAuthResult.oauth != null) {
            Request.setOAuth((String)authId, (AuthRequestEvent.OAuthRequestEvent)rawAuthResult.oauth);
        }
    }

    public void setAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability info) {
        this.authAvailability = info;
    }

    public GetAvailabilityAuthRequestEvent.AuthAvailability getAuthAvailability() {
        return this.authAvailability;
    }

    public boolean isFeatureAvailable(String name) {
        return this.authAvailability.features != null && this.authAvailability.features.contains(name);
    }

    public String getUsername() {
        if (this.rawAuthResult == null || this.rawAuthResult.playerProfile == null) {
            return "Player";
        }
        return this.rawAuthResult.playerProfile.username;
    }

    public String getMainRole() {
        if (this.rawAuthResult == null || this.rawAuthResult.permissions == null || this.rawAuthResult.permissions.getRoles() == null || this.rawAuthResult.permissions.getRoles().isEmpty()) {
            return "";
        }
        return (String)this.rawAuthResult.permissions.getRoles().get(0);
    }

    public boolean checkPermission(String name) {
        if (this.rawAuthResult == null || this.rawAuthResult.permissions == null) {
            return false;
        }
        return this.rawAuthResult.permissions.hasPerm(name);
    }

    public boolean checkDebugPermission(String name) {
        return this.application.isDebugMode() || !this.application.guiModuleConfig.disableDebugPermissions && this.checkPermission("launcher.debug." + name);
    }

    public PlayerProfile getPlayerProfile() {
        if (this.rawAuthResult == null) {
            return null;
        }
        return this.rawAuthResult.playerProfile;
    }

    public String getAccessToken() {
        if (this.rawAuthResult == null) {
            return null;
        }
        return this.rawAuthResult.accessToken;
    }

    public void exit() {
        this.rawAuthResult = null;
    }
}

